local bootup = ui.MediaPlayer()
bootup:setSource('assets/bootup.mp4'):setAutoPlay(true)

function Motec ()

    display.image {
        image = "assets/Motec_WAU.dds",
        pos = vec2(0,0),
        size = vec2(859, 480)
    }
end

function text ()

    display.text {
        text = string.format("%d", car.brake * 100),
        pos = vec2(440, 320),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -15
    }

    display.text {
        text = string.format("%.1f", ac.getCar().brakeBias * 100),
        pos = vec2(610, 375),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%d", car.rpm),
        pos = vec2(350, 380),
        letter = vec2(60, 60),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%d", car.racePosition),
        pos = vec2(135, 375),
        letter = vec2(60, 70),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    local color
if car.performanceMeter > 0 then
    color = rgbm(1, 0, 0, 1) 
elseif car.performanceMeter < 0 then
    color = rgbm(0, 1, 0, 1) 
else
    color = rgbm(1, 1, 1, 1) 
end

display.text {
    text = string.format("%.3f", car.performanceMeter), 
    pos = vec2(345, 270),
    letter = vec2(40, 45),
    font = "bosch",
    color = color, 
    width = 35,
    alignment = 1,
    spacing = -15
}

    display.text {
        text = string.format("%d", car.fuel),
        pos = vec2(140, 235),
        letter = vec2(50, 50),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -25
    }

    display.text {
        text = string.format("%.2f", car.fuel / car.fuelPerLap),
        pos = vec2(245, 270),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -22
    }
	

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.bestLapTimeMs / 60000),     
        math.floor((car.bestLapTimeMs % 60000) / 1000), 
        car.bestLapTimeMs % 1000                   
    ),
    pos = vec2(550, 250),
    letter = vec2(40, 50),
    font = "bosch",
    color = rgbm(2,0,2,2),
    width = 35,
    alignment = 1,
    spacing = -10
}

display.text {
    text = string.format("%02d:%02d.%03d", 
        math.floor(car.previousLapTimeMs / 60000),
        math.floor((car.previousLapTimeMs % 60000) / 1000), 
        car.previousLapTimeMs % 1000
    ),
    pos = vec2(550, 100),
    letter = vec2(40, 50),
    font = "bosch",
    color = rgbm(1,1,1,1),
    width = 35,
    alignment = 1,
    spacing = -10
}

    display.text {
        text = string.format("%d", car.gas * 100),
        pos = vec2(350, 320),
        letter = vec2(40, 40),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -15
    }

    display.text {
        text = string.format("%d", car.speedKmh), 
        pos = vec2(55, 60),
        letter = vec2(100, 100),
        font = "bosch",
        color = rgbm(1,1,1,1),
        width = 46,
        alignment = 1,
        spacing = -35
    }

    local gearText = tostring(car.gear) 
    if car.gear == -1 then
        gearText = "R"
    end
    if car.gear == 0 then
        gearText = "N"
    end
    display.text {
        text = gearText,
        pos = vec2(335, 70),
        letter = vec2(200, 200),
        font = "bosch",
        width = 70,
        alignment = 1,
        spacing = 0
    }
end


function images()

    if (car.batteryVoltage <= 11) then
        display.image {
            image = "assets/battery.dds",
            pos = vec2(485, 9), 
            size = vec2(40, 40)
        }
    end

    if (car.engineLifeLeft <= 600) then
        display.image {
            image = "assets/egm.dds",
            pos = vec2(440, 9), 
            size = vec2(40, 40)
        }
    end

    if (car.headlightsActive == true) then
        display.image {
            image = "assets/lights.dds",
            pos = vec2(395, 9),
            size = vec2(40, 40)
        }
    end

    if (car.fuel <= 5) then
        display.image {
            image = "assets/gas.dds",
            pos = vec2(345, 9),
            size = vec2(40, 40)
        }
    end
end

function Overrev ()
    if (car.rpm >= 8000) then
        display.image {
          image = 'assets/revwarning.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Pitlimiter ()
    if (ac.getCar().isInPitlane) then
        display.image {
          image = 'assets/pitlimiter.dds',
          pos = vec2(60,70),
        size = vec2(739, 360)
        }
    end
end

function Black_Orange ()
    if sim.raceFlagType == ac.FlagType.ReturnToPits then
        display.image {
            image = 'assets/Penalty.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Finish ()
    if sim.raceFlagType == ac.FlagType.Finished then
        display.image {
            image = 'assets/Checkeredflag.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Caution ()
    if sim.raceFlagType == ac.FlagType.Caution then
        display.image {
            image = 'assets/Caution.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end

function Blue ()
    if sim.raceFlagType == ac.FlagType.FasterCar then
        display.image {
            image = 'assets/Yourslow.dds',
            pos = vec2(0,0),
          size = vec2(859, 150)
          }
    end
end


function script.update(dt)
    if (bootup:ended()) then
        Motec()
        text()
        images()
        Overrev()
        Pitlimiter()
        Blue()
        Caution()
        Finish()
        Black_Orange()
    else
        ui.drawImage(bootup, vec2(), vec2(859, 480))
    end
end